/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.plugin.jei;

import cloud.lemonslice.teastory.recipe.drink.DrinkRecipe;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.plugin.jei.JEICompat;
import xueluoanping.teastory.registry.BlockEntityRegister;

public class DrinkMakerCategory
implements IRecipeCategory<DrinkRecipe> {
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public DrinkMakerCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableItemStack(((Item)BlockEntityRegister.DRINK_MAKER_ITEM.get()).m_7968_());
    }

    public RecipeType<DrinkRecipe> getRecipeType() {
        return JEICompat.DRINK_MAKER_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"info.teastory.drink_maker");
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(TeaStory.rl("textures/gui/jei/recipes.png"), 0, 0, 149, 75);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DrinkRecipe drinkRecipe, IFocusGroup iFocusGroup) {
        int n = drinkRecipe.m_7527_().size();
        for (int i = 0; i < n; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 39 + i * 18 + 1, 30).addIngredients((Ingredient)drinkRecipe.m_7527_().get(i));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setFluidRenderer(1000L, false, 16, 64).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)drinkRecipe.getFluidIngredient().getMatchingFluidStacks().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 127, 6).setFluidRenderer(1000L, false, 16, 64).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(drinkRecipe.getFluidResult(), 500));
    }

    public void draw(DrinkRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

